<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../classi/ColonnaInEvidenza.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new ColonnaInEvidenza($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new ColonnaInEvidenza($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $occorrenza->setClasseColonne(filter_input(INPUT_POST,"classeColonne",FILTER_SANITIZE_STRING));
            $occorrenza->setContenutoPrimaColonna(filter_input(INPUT_POST,"contenutoPrimaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setContenutoSecondaColonna(filter_input(INPUT_POST,"contenutoSecondaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setContenutoTerzaColonna(filter_input(INPUT_POST,"contenutoTerzaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setContenutoQuartaColonna(filter_input(INPUT_POST,"contenutoQuartaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setTestoPrimaColonna(filter_input(INPUT_POST,"testoPrimaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setTestoSecondaColonna(filter_input(INPUT_POST,"testoSecondaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setTestoTerzaColonna(filter_input(INPUT_POST,"testoTerzaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setTestoQuartaColonna(filter_input(INPUT_POST,"testoQuartaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->crea();
            header("Location: ../creaColonneInEvidenza.php?id={$occorrenza->getId()}&status=200");
            break;
        case 'modifica':
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $occorrenza->setClasseColonne(filter_input(INPUT_POST,"classeColonne",FILTER_SANITIZE_STRING));
            $occorrenza->setContenutoPrimaColonna(filter_input(INPUT_POST,"contenutoPrimaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setContenutoSecondaColonna(filter_input(INPUT_POST,"contenutoSecondaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setContenutoTerzaColonna(filter_input(INPUT_POST,"contenutoTerzaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setContenutoQuartaColonna(filter_input(INPUT_POST,"contenutoQuartaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setTestoPrimaColonna(filter_input(INPUT_POST,"testoPrimaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setTestoSecondaColonna(filter_input(INPUT_POST,"testoSecondaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setTestoTerzaColonna(filter_input(INPUT_POST,"testoTerzaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->setTestoQuartaColonna(filter_input(INPUT_POST,"testoQuartaColonna",FILTER_SANITIZE_STRING));
            $occorrenza->modifica();
            header("Location: ../creaColonneInEvidenza.php?id={$occorrenza->getId()}&status=250");
            break;
        case 'elimina':
            $occorrenza->elimina();
            echo "ok";
            break;
        case 'duplica':
            $occorrenza->caricaDatiDalDatabase();
            $idNuovaForm = $occorrenza->duplica();
            header("Location: ../creaOccorrenza.php?id={$idNuovaForm}&status=260");
            break;
    }
